def combine_lists_to_dict(keys, values):
    # Check if the length of the lists is the same
    if len(keys) != len(values):
        print("Error: Lists must be of the same length.")
        return None

    # Use zip to combine the lists into a list of tuples and then convert to a dictionary
    combined_dict = dict(zip(keys, values))
    return combined_dict

# Example lists
keys_list = ['name', 'age', 'city']
values_list = ['John', 25, 'New York']

# Combine lists into a dictionary
result_dict = combine_lists_to_dict(keys_list, values_list)

# Print the combined dictionary
print("Combined Dictionary:")
print(result_dict)
