import math

def distance_between_points(point1, point2):
    x1, y1 = point1
    x2, y2 = point2
    return math.sqrt((x2 - x1)**2 + (y2 - y1)**2)

def ball_collide(ball1, ball2):
    x1, y1, r1 = ball1
    x2, y2, r2 = ball2

    distance = distance_between_points((x1, y1), (x2, y2))
    sum_of_radii = r1 + r2

    return distance <= sum_of_radii

# Example usage
ball1 = (1, 3, 2)
ball2 = (4, 4, 2)

are_colliding = ball_collide(ball1, ball2)
print(f"Are the balls colliding? {are_colliding}")
