def sieve_of_eratosthenes(limit):
    primes = [True] * (limit + 1)
    primes[0] = primes[1] = False

    for i in range(2, int(limit**0.5) + 1):
        if primes[i]:
            for j in range(i*i, limit + 1, i):
                primes[j] = False

    return [num for num in range(2, limit + 1) if primes[num]]

def sum_of_primes(limit):
    prime_numbers = sieve_of_eratosthenes(limit)
    return sum(prime_numbers)

# Set the limit to two million
limit = 2000000

# Calculate and print the sum of all primes below two million
result = sum_of_primes(limit)
print(f"The sum of all prime numbers below {limit} is: {result}")
