def nearly_equal(string1, string2):
    # Check if the lengths of the strings are equal
    if len(string1) != len(string2):
        return False

    # Count the number of differing characters
    differing_chars = sum(c1 != c2 for c1, c2 in zip(string1, string2))

    # Check if there is only one differing character
    return differing_chars == 1

# Example usage
string_A = "hello"
string_B = "hullo"

result = nearly_equal(string_A, string_B)
print(f"Are the strings nearly equal? {result}")
